//
//  OPDomainVulnerabilityStatus.h
//  OnePasswordOSX
//
//  Created by Roustem Karimov on 2014-04-14.
//  Copyright (c) 2014 AgileBits Inc. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <OnePasswordCore/OnePasswordCore.h>

@class OPItem;

typedef NS_ENUM(int8_t, OPDomainVulnerabilityAction) {
	OPDomainVulnerabilityActionUnknownRetired = 0,
	OPDomainVulnerabilityActionNone = 1,
	OPDomainVulnerabilityActionUnknown = 3,
	OPDomainVulnerabilityActionChangePassword = 5,
	OPDomainVulnerabilityActionAvoid = 9
};

NSString *OPDomainVulnerabilityActionToLocalizedString(OPDomainVulnerabilityAction action);
NSString *OPLocalizedDescriptionForDomainVulnerabilityAction(OPDomainVulnerabilityAction action);

@interface OPDomainVulnerabilityStatus : NSObject

@property (nonatomic, strong) NSString *domain;
@property (nonatomic, assign) NSInteger vulnerabilityId;
@property (nonatomic, assign) OPDomainVulnerabilityAction action;
@property (nonatomic, assign) OPTimestamp actionTimestamp;

- (OPDomainVulnerabilityAction)actionForItem:(OPItem *)item;

@end
